/*
 * Decompiled with CFR 0.152.
 */
package jace.apple2e;

import jace.apple2e.SoftSwitches;
import jace.core.Card;
import jace.core.PagedMemory;
import jace.core.RAM;
import java.io.IOException;
import java.io.InputStream;

public class RAM128k
extends RAM {
    PagedMemory mainMemory = new PagedMemory(49152, PagedMemory.Type.ram);
    PagedMemory auxMemory = new PagedMemory(49152, PagedMemory.Type.ram);
    PagedMemory languageCard;
    PagedMemory languageCard2;
    PagedMemory auxLanguageCard;
    PagedMemory auxLanguageCard2;
    PagedMemory cPageRom;
    PagedMemory rom = new PagedMemory(12288, PagedMemory.Type.firmwareMain);
    PagedMemory blank;

    public RAM128k() {
        this.cPageRom = new PagedMemory(4096, PagedMemory.Type.slotRom);
        this.languageCard = new PagedMemory(12288, PagedMemory.Type.languageCard);
        this.languageCard2 = new PagedMemory(4096, PagedMemory.Type.languageCard);
        this.auxLanguageCard = new PagedMemory(12288, PagedMemory.Type.languageCard);
        this.auxLanguageCard2 = new PagedMemory(4096, PagedMemory.Type.languageCard);
        this.activeRead = new PagedMemory(65536, PagedMemory.Type.ram);
        this.activeWrite = new PagedMemory(65536, PagedMemory.Type.ram);
        this.blank = new PagedMemory(256, PagedMemory.Type.ram);
        for (int i = 0; i < 256; ++i) {
            this.blank.get((int)0)[i] = -1;
            for (int j = 0; j < 192; ++j) {
                this.mainMemory.get((int)j)[i] = (byte)(i % 4 > 1 ? 0 : 255);
            }
        }
    }

    public void configureActiveMemory() {
        int i;
        block22: {
            block20: {
                block21: {
                    this.activeRead.fillBanks(SoftSwitches.AUXRD.getState() ? this.auxMemory : this.mainMemory);
                    this.activeWrite.fillBanks(SoftSwitches.AUXWR.getState() ? this.auxMemory : this.mainMemory);
                    this.activeRead.fillBanks(this.rom);
                    for (i = 192; i < 208; ++i) {
                        this.activeWrite.set(i, null);
                    }
                    if (SoftSwitches.LCRAM.getState()) {
                        if (SoftSwitches.AUXZP.getState()) {
                            this.activeRead.fillBanks(this.languageCard);
                            if (!SoftSwitches.LCBANK1.getState()) {
                                this.activeRead.fillBanks(this.languageCard2);
                            }
                        } else {
                            this.activeRead.fillBanks(this.auxLanguageCard);
                            if (!SoftSwitches.LCBANK1.getState()) {
                                this.activeRead.fillBanks(this.auxLanguageCard2);
                            }
                        }
                    }
                    if (!SoftSwitches.LCWRITE.getState()) break block20;
                    if (!SoftSwitches.AUXZP.getState()) break block21;
                    this.activeWrite.fillBanks(this.languageCard);
                    if (!SoftSwitches.LCBANK1.getState()) {
                        this.activeWrite.fillBanks(this.languageCard2);
                    }
                    break block22;
                }
                this.activeWrite.fillBanks(this.auxLanguageCard);
                if (SoftSwitches.LCBANK1.getState()) break block22;
                this.activeWrite.fillBanks(this.auxLanguageCard2);
                break block22;
            }
            for (i = 208; i < 256; ++i) {
                this.activeWrite.set(i, null);
            }
        }
        if (SoftSwitches._80STORE.isOn()) {
            this.activeRead.setBanks(4, 4, 4, SoftSwitches.PAGE2.isOn() ? this.auxMemory : this.mainMemory);
            this.activeWrite.setBanks(4, 4, 4, SoftSwitches.PAGE2.isOn() ? this.auxMemory : this.mainMemory);
            if (SoftSwitches.HIRES.isOn()) {
                this.activeRead.setBanks(32, 32, 32, SoftSwitches.PAGE2.isOn() ? this.auxMemory : this.mainMemory);
                this.activeWrite.setBanks(32, 32, 32, SoftSwitches.PAGE2.isOn() ? this.auxMemory : this.mainMemory);
            }
        }
        if (SoftSwitches.AUXZP.getState()) {
            this.activeRead.setBanks(0, 2, 0, this.auxMemory);
            this.activeWrite.setBanks(0, 2, 0, this.auxMemory);
        } else {
            this.activeRead.setBanks(0, 2, 0, this.mainMemory);
            this.activeWrite.setBanks(0, 2, 0, this.mainMemory);
        }
        if (SoftSwitches.CXROM.getState()) {
            this.activeRead.setBanks(0, 15, 193, this.cPageRom);
        } else {
            for (int slot = 1; slot <= 7; ++slot) {
                Card c = this.getCard(slot);
                if (c != null) {
                    this.activeRead.setBanks(0, 1, 192 + slot, c.getCxRom());
                    if (this.getActiveSlot() != slot) continue;
                    this.activeRead.setBanks(0, 8, 200, c.getC8Rom());
                    continue;
                }
                this.activeRead.set(192 + slot, this.blank.get(0));
            }
            if (this.getActiveSlot() == 0) {
                for (i = 200; i < 208; ++i) {
                    this.activeRead.set(i, this.blank.get(0));
                }
            }
            if (SoftSwitches.SLOTC3ROM.isOff()) {
                this.activeRead.setBanks(2, 1, 195, this.cPageRom);
            }
            if (SoftSwitches.INTC8ROM.getState()) {
                this.activeRead.setBanks(7, 8, 200, this.cPageRom);
            }
        }
        this.activeRead.set(192, this.blank.get(0));
    }

    protected void loadRom(String path) throws IOException {
        byte[] ignore = new byte[256];
        this.activeWrite.set(0, ignore);
        for (int i = 1; i < 17; ++i) {
            this.activeWrite.set(i, ignore);
        }
        this.activeWrite.setBanks(0, this.cPageRom.getMemory().length, 17, this.cPageRom);
        this.activeWrite.setBanks(0, this.rom.getMemory().length, 32, this.rom);
        InputStream inputRom = RAM128k.class.getClassLoader().getResourceAsStream(path);
        int read = 0;
        int addr = 0;
        byte[] in = new byte[1024];
        while (addr < 65535 && (read = inputRom.read(in)) > 0) {
            for (int i = 0; i < read; ++i) {
                this.write(addr++, in[i], false);
            }
        }
        System.out.println("Finished reading rom with " + inputRom.available() + " bytes left unread!");
        this.configureActiveMemory();
    }
}

